

#ifdef MACVERSION
	#include <standard.h>
	#include "OSXSpecifics.h"
	#include "player.h" /*7.0b4: QuickTime Player*/
#endif
#ifdef WIN95VERSION
	#include "standard.h"
#endif

#include "about.h"

#include "frontierconfig.h"
#include "db.h" /*stats*/
#include "file.h" /*6.1b15 AR: filestart*/
#include "shell.h"
#include "lang.h"
#include "langinternal.h"
#include "langexternal.h"
#include "tableverbs.h"
#include "opverbs.h"
#include "scripts.h"
#include "menuverbs.h"
#include "pictverbs.h"
#include "wpverbs.h"
#include "cancoon.h"
#include "command.h"
#ifdef flcomponent
	#include "osacomponent.h"
#endif
#ifdef fliowa
	#include "iowaverbs.h" /*3/18/92 dmb*/
#endif
#include "frontierstart.h"


boolean frontierstart (void) {
	
	/*
	do all initialization and starting up. on failure, exit to shell; only
	return to caller on success
	
	3.0.4b6 dmb: call osacomponentstart from here, after the shell
	is more thoroughly initialized.
	*/
	
	iddefaultconfig = idcancoonconfig;
//	iddefaultconfig = idscriptconfig;
	
	if (!filestart ()) /*6.1b16*/
		return (false);

	if (!opstart ())
		return (false);
	
	if (!menustart ())
		return (false);
	
	if (!tablestart ())
		return (false);
	
	if (!scriptstart ())
		return (false);
		
	if (!pictstart ())
		return (false);
	
	if (!wpstart ())
		return (false);
	
	#ifdef version42orgreater
	
	if (!aboutstart ())
		return (false);
		
		#ifdef MACVERSION

/*
		useQDText(0); // set to 1 for Quartz rendering.
*/
	
		if (!playerstart ()) /*7.0b4 PBS: QuickTime Player*/
			return (false);
	
		#endif
	
	#endif
	
	if (!cmdstart ())
		return (false);
	
	if (!langdialogstart ())
		return (false);
	
	if (!langerrorstart ())
		return (false);
	
	if (!statsstart ())
		return (false); 
	
	#ifdef iowaRuntime
	
	if (!langcardstart ())
		return (false);

	#endif
	
	if (!ccstart ())
		return (false);
	
	#ifdef flcomponent
	
	//#if !TARGET_API_MAC_CARBON
	//Code change by Timothy Paustian Saturday, July 8, 2000 9:47:28 PM
	//The carbon version just does not play nice with the component manager.
	//at some point I have to figure this out.
	if (!osacomponentstart ())
		;	// don't quit if this doesn't work
	//#endif

	#endif
	
	if (!shellstart ())
		return (false);
	
	return (true);
	} /*frontierstart*/



